[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Expert)"
set var=CONF_DESCRIPTION value="tr(3,Routed PPPoA Packet Service configuration using IPCP subnet mask.)"
set var=CONF_SERVICE value="tr(4,Routed PPPoA - IPCP subnet Mask)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value="8.35"

[ wizard.ini ]
' ATM=PVC Settings
'----------------------------
def var=ATM type=grp desc="tr(5,Specify the details of the Routed PPPoA Packet Service. All information should be provided by your ISP.)" alias="tr(6,Routed PPPoA Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" req=yes desc="tr(7,Choose a VPI/VCI from the list)" default=8.35
' PPP=Settings
'-------------
def var=PPP type=grp desc="tr(8,Specify the details of the Routed PPP Account. All information should be provided by your ISP.)" alias="tr(9,PPP Account Settings)"
def var=PPP_user type=string grp=PPP alias="tr(10,User Name)" req=yes desc="tr(11,Enter your Internet connection user name.)"
def var=%PPP_pwd type=passw grp=PPP alias="tr(12,Password)" req=yes desc="tr(13,Enter your Internet connection password.)" max=32
'ST Security
'-----------
def var=ST type=grp desc="tr(14,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(15,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(16,User Name)" desc="tr(17,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(18,Password)" desc="tr(19,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(20,Confirm Password)" desc="tr(21,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=PVC_1 addr=$ATM_addr type=any
add name=USB addr=usb.0.35 type=any logging=off

[ bridge.ini ]
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
config autodhcp=on scantime=10 state=enabled trace=off
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=10.0.0.1 poolend=10.0.0.254 netmask=255.255.255.0 gateway=10.0.0.138 leasetime=30
pool add name="IPCP_pool"
pool config name="IPCP_pool" index=0 leasetime=30

[ ethoa.ini ]

[ ipoa.ini ]

[ pppoa.ini ]
ifadd intf=PPPoA_1
ifconfig intf=PPPoA_1 dest=PVC_1 user=$PPP_user password=$%PPP_pwd accomp=on addrtrans=none format=cidr restart=on pool=IPCP_pool
ifattach intf=PPPoA_1

[ pppoe.ini ]

[ pppoerelay.ini ]

[ cip.ini ]

[ ip.ini ]
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0

[ dhcr.ini ]
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138

[ autopvc.ini ]
config mode=passive type=bridge

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ upnp.ini ]
config defcservice=PPPoA_1

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Expert"
t r="3, Configuratie met routed-PPPoA Packet-service en IPCP-subnetmasker."
t r="4, Routed PPPoA - IPCP-subnetmasker"
t r="5, Geef de details van de routed-PPPoA Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Routed-PPPoA Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Geef de details van de routed-PPP-account op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="9, Instellingen van PPP-account"
t r="10, Gebruikersnaam"
t r="11, Geef de gebruikersnaam voor uw Internet-verbinding in."
t r="12, Wachtwoord"
t r="13, Geef het wachtwoord voor uw Internet-verbinding in."
t r="14, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="15, SpeedTouch-beveiliging"
t r="16, Gebruikersnaam"
t r="17, Geef uw gebruikersnaam in."
t r="18, Wachtwoord"
t r="19, Geef uw wachtwoord in."
t r="20, Wachtwoord bevestigen"
t r="21, Geef uw wachtwoord nogmaals in."
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Expert"
t r="3, Configuration du service de transmission par paquets PPPoA rout avec le masque de sous-rseau IPCP."
t r="4, PPPoA rout, IPCP"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets PPPoA rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets PPPoA rout"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Spcifiez les dtails relatifs au compte de la connexion PPP route. Toutes ces informations doivent tre fournies par votre FAI."
t r="9, Paramtres du compte PPP"
t r="10, Nom d'utilisateur"
t r="11, Entrez le nom d'utilisateur employ pour votre connexion  Internet."
t r="12, Mot de passe"
t r="13, Entrez le mot de passe employ pour votre connexion  Internet."
t r="14, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="15, Scurit SpeedTouch"
t r="16, Nom d'utilisateur"
t r="17, Entrez un nom d'utilisateur."
t r="18, Mot de passe"
t r="19, Entrez votre mot de passe."
t r="20, Confirmer le mot de passe"
t r="21, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Expert"
t r="3, Konfiguration des Routed PPPoA-Paketdienstes unter Verwendung einer IPCP-Subnetzmaske."
t r="4, Routed PPPoA - IPCP-Subnetzmaske"
t r="5, Geben Sie die Einzelheiten zum Routed PPPoA-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Routed PPPoA-Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Geben Sie die Einzelheiten zum Routed PPP-Konto an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="9, Einstellungen fr das PPP-Konto"
t r="10, Benutzername"
t r="11, Geben Sie den Benutzernamen fr die Internetverbindung ein."
t r="12, Kennwort"
t r="13, Geben Sie das Kennwort fr die Internetverbindung ein."
t r="14, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="15, SpeedTouch Sicherheit"
t r="16, Benutzername"
t r="17, Geben Sie den Benutzernamen ein."
t r="18, Kennwort"
t r="19, Geben Sie das Kennwort ein."
t r="20, Kennwort besttigen"
t r="21, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Esperta"
t r="3, Configurazione per la trasmissione di pacchetti in modalit routed PPPoA con subnet mask IPCP."
t r="4, Routed PPPoA - Subnet mask IPCP"
t r="5, Specificare i dettagli per la trasmissione di pacchetti in modalit routed PPPoA. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Trasmissione di pacchetti in modalit routed PPPoA"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Specificare i dettagli dell'account routed PPP. Tutte le informazioni devono essere fornite dall'ISP."
t r="9, Impostazioni account PPP"
t r="10, Nome utente"
t r="11, Immettere il nome utente di connessione a Internet."
t r="12, Password"
t r="13, Immettere la password di connessione a Internet."
t r="14, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="15, Sicurezza SpeedTouch"
t r="16, Nome utente"
t r="17, Immettere il nome utente."
t r="18, Password"
t r="19, Immettere la password."
t r="20, Conferma password"
t r="21, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Avanado"
t r="3, Configurao do Servio de Pacote do PPPoA Roteado usando mscara de sub-rede IPCP."
t r="4, PPPoA roteado - Mscara de sub-rede IPCP"
t r="5, Especifique os detalhes do Routed PPPoA Packet Service. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote do PPPoA Roteado"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Especifique os detalhes da Conta do PPP Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="9, Configuraes da Conta do PPP"
t r="10, Nome do usurio"
t r="11, Digite seu nome do usurio de conexo com a Internet."
t r="12, Senha"
t r="13, Digite sua senha de conexo com a Internet."
t r="14, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="15, Segurana do SpeedTouch"
t r="16, Nome do usurio"
t r="17, Digite o nome do usurio."
t r="18, Senha"
t r="19, Digite sua senha."
t r="20, Confirme a senha"
t r="21, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Experto"
t r="3, Configuracin del servicio de paquetes PPPoA enrutados mediante una mscara de subred IPCP."
t r="4, PPPoA enrutados; mscara de subred IPCP"
t r="5, Indique los detalles del servicio de paquetes PPPoA enrutados. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicio de paquetes PPPoA enrutados"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Indique los detalles de la cuenta PPP enrutada. Toda la informacin debe proporcionarla el ISP."
t r="9, Configuracin de cuentas PPP"
t r="10, Nombre de usuario"
t r="11, Escriba el nombre de usuario de conexin a Internet."
t r="12, Contrasea"
t r="13, Escriba la contrasea de conexin a Internet."
t r="14, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="15, Seguridad de SpeedTouch"
t r="16, Nombre de usuario"
t r="17, Escriba el nombre de usuario."
t r="18, Contrasea"
t r="19, Escriba la contrasea."
t r="20, Confirme la contrasea"
t r="21, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Expert"
t r="3, Konfiguration fr Routed PPPoA Packet Service som anvnder IPCP-subntmask."
t r="4, Routed PPPoA - IPCP-subntmask"
t r="5, Ange information om Routed PPPoA Packet Service. Din ISP ska kunna ge all information."
t r="6, Routed PPPoA Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Ange information om kontot fr Routed PPP. Din ISP ska kunna ge all information."
t r="9, Kontoinstllningar fr PPP"
t r="10, Anvndarnamn"
t r="11, Ange anvndarnamn fr din Internet-anslutning."
t r="12, Lsenord"
t r="13, Ange lsenord fr din Internet-anslutning."
t r="14, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="15, SpeedTouch-skerhet"
t r="16, Anvndarnamn"
t r="17, Ange anvndarnamn."
t r="18, Lsenord"
t r="19, Ange lsenord."
t r="20, Bekrfta lsenord"
t r="21, Ange ditt lsenord igen"

[ endofarch ]
